﻿using System.Drawing;
using System.Windows.Forms;
using System.Reflection;

namespace Spectral1.SPECTRUM_ANALYSER
{
    public partial class UC_spectrum_display : UserControl
    {
        #region "===================== DECLARATIONS ========================="
        Point[] _spectrum_display;
        Point[] _spectrum_ra_display;
        Brush column_brush = new SolidBrush(Color.SpringGreen);
        Font label_font = new Font("Segoe UI", 8);
        Brush label_brush = new SolidBrush(Color.Yellow);
        Pen axis_pen = new Pen(Color.Yellow);
        Pen fft_ra_pen = new Pen(Color.White);
        int centre_y = 200;
        double fft_freq_label_x_step;
        double hz_per_horiz_pixel;
        #endregion

        #region "==================== PROPERTIES ========================"

        public Rectangle display_rectangle 
        {
            get{ return panel1.ClientRectangle; }
        }

        public bool display_low_freq_only
        {
            get { return checkBox_low_freq.Checked; }
        }
        #endregion

        #region "===================== EVENTS ========================="

        private void panel1_Paint_1(object sender, PaintEventArgs e)
        {
            if (_spectrum_display == null) return;

            //Tick marks and labels
            int y = panel1.ClientRectangle.Height - c_spectrum_analyser.horiz_axis_y_offset + 5;
            e.Graphics.DrawLine(axis_pen, 0, y-5, panel1.ClientRectangle.Width, y - 5);
            int label_x, tick_x;
            for (int i = 0; i < 10; i++)
            {
                tick_x = (int)(fft_freq_label_x_step * i);
                if (i > 0) { label_x = tick_x - 10; } else { label_x = tick_x; }
                int f = (int)(i * fft_freq_label_x_step * hz_per_horiz_pixel);
                e.Graphics.DrawLine(axis_pen, tick_x, y, tick_x, y - 5);
                e.Graphics.DrawString(f.ToString(), label_font, label_brush, label_x, y);
            }
            e.Graphics.DrawString("Hz", label_font, label_brush, (panel1.ClientRectangle.Width / 2) - 4, y + 20);

            //Plots
            switch (comboBox_display_options.Text)
            {
                case "Real-time and average":
                    e.Graphics.DrawLines(fft_ra_pen, _spectrum_ra_display);
                    e.Graphics.FillPolygon(column_brush, _spectrum_display);
                    break;
                case "Average only":
                    e.Graphics.DrawLines(fft_ra_pen, _spectrum_ra_display);
                    break;
                case "Real-time only":
                    e.Graphics.FillPolygon(column_brush, _spectrum_display);

                    break;
            }

        }

        private void comboBox_display_options_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            this.Refresh();
        }

        private void checkBox_low_freq_CheckedChanged(object sender, System.EventArgs e)
        {
            set_hz_per_horiz_pixel();
            this.Refresh();
        }

        #endregion

        #region "===================== METHODS ========================="
        public UC_spectrum_display()
        {
            InitializeComponent();
            comboBox_display_options.Text = "Real-time and average";
        }

        private void set_hz_per_horiz_pixel()
        {
            if (checkBox_low_freq.Checked)
            { hz_per_horiz_pixel = c_spectrum_analyser.fft_sample_rate / 8.0 / panel1.ClientRectangle.Width; }
            else
            { hz_per_horiz_pixel = c_spectrum_analyser.fft_sample_rate / 4.0 / panel1.ClientRectangle.Width; }
        }

        public void initialise()
        {
            centre_y = panel1.ClientRectangle.Height / 2;
            fft_freq_label_x_step = (double)panel1.ClientRectangle.Width / 10.0;
            set_hz_per_horiz_pixel();

            typeof(Panel).InvokeMember("DoubleBuffered", BindingFlags.SetProperty
            | BindingFlags.Instance | BindingFlags.NonPublic, null,
            panel1, new object[] { true });
        }
        #endregion

        public void refresh_spectrum_display(Point[] spectrum_display, Point[] spectrum_ra_display)
        {
            _spectrum_display = spectrum_display;
            _spectrum_ra_display = spectrum_ra_display;
            this.Refresh();
        }


    }
}
